from src.bulletEnv import BulletEnv
from stable_baselines3.common.vec_env import SubprocVecEnv
from stable_baselines3.common.monitor import Monitor
from typing import Callable
import os

def setup_dirs(config, runid):
    os.makedirs(os.path.join(config['action_logs'],
                             config['robot']['name'],
                             config['env_name'],
                             runid), exist_ok=True)
    os.makedirs(os.path.join(config['policy_logs'],
                             config['robot']['name'],
                             config['env_name'],
                             runid), exist_ok=True)
    os.makedirs(os.path.join(config['policy_folder'], runid), exist_ok=True)
    os.makedirs(config["results_folder"], exist_ok=True)

def make_env(env) -> Callable:
    """
    Utility function for multiprocessed env.
    
    :param env_id: (str) the environment ID
    :param num_env: (int) the number of environment you wish to have in subprocesses
    :param seed: (int) the inital seed for RNG
    :param rank: (int) index of the subprocess
    :return: (Callable)
    """
    def _init():
        return env
    return _init

def make_subproc_envs(init_set, term_set, term_sampler,option_guide,region_switch_point,demo_mode, robot_config, env_path, num, gui,max_ep_len, monitor=False,forked=True,env_prefix='',seed=1337):
    
    if monitor:
        return Monitor(BulletEnv(seed=seed,
                        gui=gui,
                        init_set=init_set,
                        term_set=term_set,
                        term_sampler = term_sampler,
                        option_guide= option_guide,
                        region_switch_point=region_switch_point,
                        demo_mode=demo_mode,
                        robot_config=robot_config,
                        env_path=env_path,
                        envid='eval',
                        max_ep_len=max_ep_len))
    envs = []
    for i in range(num):
        # Each environment must have a different seed
        envs.append(make_env(BulletEnv(seed=seed+(i+1)*2,
                        gui=gui,
                        init_set=init_set,
                        term_set=term_set,
                        term_sampler = term_sampler,
                        option_guide= option_guide,
                        region_switch_point=region_switch_point,
                        demo_mode=demo_mode,
                        robot_config=robot_config,
                        forked=forked,
                        env_path=env_path,
                        envid=env_prefix+str(i+1),
                        max_ep_len=max_ep_len))
                    )
    
    subproc_envs = SubprocVecEnv(envs, start_method='spawn')
    return subproc_envs

# def create_env_info_dict():
#     return {
#             "action_count":0,
#             "done_count":0,
#             "reward":0,
#             "cumreward":0,
#             "episode_reward":[[0,0]],
#             "action":None,
#             "desired_pos":[],
#             "achieved_pos":[],
#             "pos_difference":0
#         }